/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;

public class SonarLintProjectDecorator
implements ILightweightLabelDecorator {
    public static final String ID = "org.sonarlint.eclipse.ui.sonarlintDecorator";
    private ListenerList fListeners;

    public void decorate(Object element, IDecoration decoration) {
        IProject project = null;
        if (element instanceof IProject) {
            project = (IProject)element;
        } else if (element instanceof IAdaptable) {
            project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
        }
        if (project != null && project.isAccessible()) {
            SonarLintProject p = SonarLintProject.getInstance((IResource)project);
            if (!p.isAutoEnabled()) {
                return;
            }
            if (p.getServerId() != null && ServersManager.getInstance().getServer(p.getServerId()) != null) {
                decoration.addOverlay(SonarLintImages.SQ_LABEL_DECORATOR);
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fListeners != null) {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                this.fListeners.remove(listeners[i]);
                ++i;
            }
            this.fListeners = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)listener);
    }

    public void fireChange(IProject[] elements) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])elements);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }
}

